#include <Struct.h>

BOOL IsPointInRect(POINT& p, POINT& one, POINT& two)
{
  return  ((p.x > one.x) && (p.x < two.x) || (p.x < one.x) && (p.x > two.x)) &&
          ((p.y > one.y) && (p.y < two.y) || (p.y < one.y) && (p.y > two.y));
}

BOOL IsPointInCirc(tNormalVertex* v, tPOINT* center, tPOINT* rad, z3dViewDescriptor* pView)
{
  POINT pv, pc;
  pv = ConvertToScreen(v->X, v->Y, v->Z, pView);
  pc = ConvertToScreen(center->x, center->y, center->z, pView);
  if ((rad->x < MINFLOAT) || (rad->y < MINFLOAT))
    return FALSE;

  return  (pc.x-pv.x)*(pc.x-pv.x)/(rad->x*rad->x) + 
          (pc.y-pv.y)*(pc.y-pv.y)/(rad->y*rad->y) < 1.0f;
}


void ProcessSelection(
						tObject* obj,
						UINT nFlags,
						tPOINT *min,    // or center.
						tPOINT *max,    // or radiuses
            z3dViewDescriptor* pView,
						BOOL CrossingEnough,
						WORD ShapeType) // 0 - rect, 1-circle
{
	BOOL SelectResult = !CrossingEnough; //??? not sure!
	
	if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) && !obj->AllowGenericEdit())
    return;
	if (!CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) && !obj->AllowLowLevelEdit())
    return;
	if ((pView->Kind == Z3D_VIEWMODE_MAPPER) != (0==strcmp(obj->ObjectName, "UVMapperDATA")))
    return;

	if ((CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_FACES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
		&& !obj->Marked())
		return;

	POINT p1,p2,p3;
	POINT pmin, pmax;
	tNormalVertex v;
  pmin = ConvertToScreen(min->x, min->y, min->z, pView);
  pmax = ConvertToScreen(max->x, max->y, max->z, pView);


	//////////// Rect Selection /////////////////
	if (ShapeType==0)
	{
		if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || (CurrentState.nCurrentViewFlags & Z3D_VIEWFLAG_SEETHROUGH))
		{//check see through
			if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
			for (	VertCount=0;
				VertCount < obj->VertTable->VertAmount;
				VertCount++)
			{//for
				obj->VertTable->Table[VertCount].UnMark();
        if (pView->Kind == Z3D_VIEWMODE_USER)
        {
          p1 = ConvertToScreen( obj->VertTable->Table[VertCount].X,
                                obj->VertTable->Table[VertCount].Y,
                                obj->VertTable->Table[VertCount].Z,
                                pView);
          if (IsPointInRect(p1, pmin, pmax))
          {
					  obj->VertTable->Table[VertCount].Mark();
					  SelectResult = TRUE;
          }
        }
        else
        {
				  if (obj->VertTable->Table[VertCount].InRectRegion(min, max, CrossingEnough))
				  {
					  obj->VertTable->Table[VertCount].Mark();
					  SelectResult = TRUE;
				  }
        }
			}//for
			if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
			for (	FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
			{//for
				obj->FaceTable->Table[FaceCount].UnMark();
				v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
				v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
				v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
        p1 = ConvertToScreen( v.X,
                              v.Y,
                              v.Z,
                              pView);
        if (((pView->Kind == Z3D_VIEWMODE_USER) && (IsPointInRect(p1, pmin, pmax)) ||
            (pView->Kind != Z3D_VIEWMODE_USER) && v.InRectRegion(min, max, CrossingEnough)))
        {
					obj->FaceTable->Table[FaceCount].Mark();
					SelectResult = TRUE;
        }
			}//for
		}//check see through
		else
		{
			for (	FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
			{//for
				p1 = ConvertToScreen(	obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z,
										pView);
				p2 = ConvertToScreen(	obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z,
										pView);
				p3 = ConvertToScreen(	obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,
										pView);
				if (IsFaceVisible(p1,p2,p3))
				{//ok-visible
					if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
					{
						obj->FaceTable->Table[FaceCount].UnMark();
						v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
						v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
						v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
            p1 = ConvertToScreen( v.X,
                                  v.Y,
                                  v.Z,
                                  pView);
            if (((pView->Kind == Z3D_VIEWMODE_USER) && (IsPointInRect(p1, pmin, pmax)) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && v.InRectRegion(min, max, CrossingEnough)))
            {
					    obj->FaceTable->Table[FaceCount].Mark();
					    SelectResult = TRUE;
            }
					}
					if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
					{
						obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].UnMark();
						obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].UnMark();
						obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].UnMark();
            if (pView->Kind == Z3D_VIEWMODE_USER)
            {
              p1 = ConvertToScreen( obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z,
                                    pView);
              if (IsPointInRect(p1, pmin, pmax))
              {
					      obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Mark();
					      SelectResult = TRUE;
              }
            }
            else
				      if (obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].InRectRegion(min, max, CrossingEnough))
				      {
					      obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Mark();
					      SelectResult = TRUE;
				      }
            if (pView->Kind == Z3D_VIEWMODE_USER)
            {
              p1 = ConvertToScreen( obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z,
                                    pView);
              if (IsPointInRect(p1, pmin, pmax))
              {
					      obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Mark();
					      SelectResult = TRUE;
              }
            }
            else
				      if (obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].InRectRegion(min, max, CrossingEnough))
				      {
					      obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Mark();
					      SelectResult = TRUE;
				      }
            if (pView->Kind == Z3D_VIEWMODE_USER)
            {
              p1 = ConvertToScreen( obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,
                                    pView);
              if (IsPointInRect(p1, pmin, pmax))
              {
					      obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Mark();
					      SelectResult = TRUE;
              }
            }
            else
				      if (obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].InRectRegion(min, max, CrossingEnough))
				      {
					      obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Mark();
					      SelectResult = TRUE;
				      }
					}
				}//ok-visible
			}//for
		}//seethrough mode
	}//quadr

	////////////// Circ Selection /////////////////
	if (ShapeType==1)
	{
		if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || (CurrentState.nCurrentViewFlags & Z3D_VIEWFLAG_SEETHROUGH))
		{//check see through
			if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
			for (	VertCount=0;
				VertCount < obj->VertTable->VertAmount;
				VertCount++)
			{//for
				obj->VertTable->Table[VertCount].UnMark();
        if (pView->Kind == Z3D_VIEWMODE_USER)
        {
          if (IsPointInCirc(&obj->VertTable->Table[VertCount], min, max, pView))
          {
					  obj->VertTable->Table[VertCount].Mark();
					  SelectResult = TRUE;
          }
        }
        else
        {
				  if (obj->VertTable->Table[VertCount].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
				  {
					  obj->VertTable->Table[VertCount].Mark();
					  SelectResult = TRUE;
				  }
        }

			}//for
			if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
			for (	FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
			{//for
				obj->FaceTable->Table[FaceCount].UnMark();
				v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
				v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
				v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
        if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&v, min, max, pView) ||
            (pView->Kind != Z3D_VIEWMODE_USER) && v.InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
				{
					obj->FaceTable->Table[FaceCount].Mark();
					SelectResult = TRUE;
				}
			}//for
		}//check see through
		else
		{
			for (	FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
			{//for
				p1 = ConvertToScreen(	obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z,
										pView);
				p2 = ConvertToScreen(	obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z,
										pView);
				p3 = ConvertToScreen(	obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,
										obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,
										pView);
				if (IsFaceVisible(p1,p2,p3))
				{//ok-visible
					if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
					{
						obj->FaceTable->Table[FaceCount].UnMark();
						v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
						v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
						v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&v, min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && v.InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
				    {
					    obj->FaceTable->Table[FaceCount].Mark();
					    SelectResult = TRUE;
				    }
					}
					if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
					{
						obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].UnMark();
						obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].UnMark();
						obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].UnMark();
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1], min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
						{
							obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Mark();
							SelectResult = TRUE;
						}
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2], min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
						{
							obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Mark();
							SelectResult = TRUE;
						}
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3], min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
						{
							obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Mark();
							SelectResult = TRUE;
						}
					}
				}//ok-visible
			}//for
		}//seethrough mode
	}//circ

	///////////// Selection processing: Add/Remove //////////////
	if (SelectResult)
	{//valid selection
		if ((CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES)) && !((nFlags & MK_CONTROL) == MK_CONTROL))
		{
			for (
          VertCount=0;
					VertCount < obj->VertTable->VertAmount;
					VertCount++)
			obj->VertTable->Table[VertCount].ToHasFlagSetFlag(	TRUE, FALSE, FALSE, FALSE,
																FALSE, FALSE, TRUE, TRUE,
																TRUE, TRUE, FALSE, FALSE);
		}
		if (CurrentState.IsLevel(Z3D_LEVEL_FACES) && !((nFlags & MK_CONTROL) == MK_CONTROL))
		{
			for (	FaceCount=0;
					FaceCount < obj->FaceTable->FaceAmount;
					FaceCount++)
			obj->FaceTable->Table[FaceCount].ToHasFlagSetFlag(	TRUE, FALSE, FALSE, FALSE,
																FALSE, FALSE, TRUE, TRUE,
																TRUE, TRUE, FALSE, FALSE);
		}
		if (((nFlags & MK_CONTROL)==MK_CONTROL) && (CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES)))
		{
			for (	VertCount=0;
					VertCount < obj->VertTable->VertAmount;
					VertCount++)
			obj->VertTable->Table[VertCount].ToHasFlagSetFlag(	TRUE, FALSE, FALSE, FALSE,
																FALSE, FALSE, TRUE, TRUE,
																FALSE, FALSE, FALSE, FALSE);
		}
		if (((nFlags & MK_CONTROL)==MK_CONTROL) && CurrentState.IsLevel(Z3D_LEVEL_FACES))
		{
			for (	FaceCount=0;
					FaceCount < obj->FaceTable->FaceAmount;
					FaceCount++)
			obj->FaceTable->Table[FaceCount].ToHasFlagSetFlag(	TRUE, FALSE, FALSE, FALSE,
																FALSE, FALSE, TRUE, TRUE,
																FALSE, FALSE, FALSE, FALSE);
		}
		if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
		{
			if (!CrossingEnough)
				for (	VertCount=0;
						VertCount < obj->VertTable->VertAmount && SelectResult;
						VertCount++)
				SelectResult = obj->VertTable->Table[VertCount].Marked();
			if (SelectResult)
			{
				if ((nFlags & MK_CONTROL)==MK_CONTROL)
					{obj->UnSelect();obj->VertTable->UnSelectAll();}
				else/// + shift or nothing pressed additional.////
					{obj->Select(); obj->VertTable->SelectAll();}
			}
		}
	}
	obj->VertTable->UnMarkAll();
	obj->FaceTable->UnMarkAll();
  obj->nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
}//selector



DWORD CALLBACK QuadrOnRButtonUp(tProcParams* params)
{
	////////////////////////
	//S E L E C T I O N	DRAG
	////////////////////////
	if (CurrentState.IsLevel(Z3D_LEVEL_SPLINES) ||
		CurrentState.IsLevel(Z3D_LEVEL_SPLINEVERTICES) ||
		CurrentState.IsLevel(Z3D_LEVEL_NONE) ||
		CurrentState.IsLevel(Z3D_LEVEL_NORMALS))
		return 0;

	//////////////////////////////////////////
	// using standart flags backup function
	/////////////////////////////////////////
	
	if (CurrentState.UndoMaxSteps > 0)	
		Backup(Z3D_BACKUP_FLAGS, "Quadr selection", FALSE, params);


	tPOINT start;
	tPOINT end;
	tPOINT Screen1,Screen2;
	POINT lp = ConvertToScreen(
					params->LastPressedAt->x,
					params->LastPressedAt->y,
					params->LastPressedAt->z,
					params->ViewDesc);
	Screen1 = ConvertFromScreen(lp.x, lp.y, params->ViewDesc);
	Screen2 = ConvertFromScreen(params->loc->x, params->loc->y, params->ViewDesc);
	start.x = minimum(Screen1.x, Screen2.x);
	start.y = minimum(Screen1.y, Screen2.y);
	start.z = minimum(Screen1.z, Screen2.z);
	end.x = maximum(Screen1.x, Screen2.x);
	end.y = maximum(Screen1.y, Screen2.y);
	end.z = maximum(Screen1.z, Screen2.z);
	if (IsTop(params->ViewDesc->Kind)) {start.y = -MAXFLOAT;end.y = MAXFLOAT;}
	if (IsSide(params->ViewDesc->Kind)){start.x = -MAXFLOAT;end.x = MAXFLOAT;}
	if (IsFrontal(params->ViewDesc->Kind) ||
      (params->ViewDesc->Kind==Z3D_VIEWMODE_MAPPER)) {start.z = -MAXFLOAT;end.z = MAXFLOAT;}
  if (params->ViewDesc->Kind==Z3D_VIEWMODE_USER)
  {
    start = Screen1;
    end = Screen2;
  }
	for (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
	{
		ProcessSelection(&params->Objects->ObjSet[ObjCount], *params->nFlags, &start, &end,
			params->ViewDesc, ((*params->nFlags & MK_SHIFT)==MK_SHIFT), 0); //0 is quadr
	}
	return Z3D_PLUGRESULT_SELECTIONCHANGED;
}


DWORD CALLBACK CircleOnRButtonUp(tProcParams* params)
{
	////////////////////////
	//	SELECTION	CIRCLE
	////////////////////////
	if (CurrentState.IsLevel(Z3D_LEVEL_SPLINES) ||
		CurrentState.IsLevel(Z3D_LEVEL_SPLINEVERTICES) ||
		CurrentState.IsLevel(Z3D_LEVEL_NONE) ||
		CurrentState.IsLevel(Z3D_LEVEL_NORMALS))
		return 0;

	//////////////////////////////////////////
	// using standart flags backup function
	/////////////////////////////////////////
	
	if (CurrentState.UndoMaxSteps > 0)	
		Backup(Z3D_BACKUP_FLAGS, "Circle selection", FALSE, params);


	tPOINT radius;
	float radiusx, radiusy;
	POINT lp = ConvertToScreen(
					params->LastPressedAt->x,
					params->LastPressedAt->y,
					params->LastPressedAt->z,
					params->ViewDesc);

	tPOINT Center = ConvertFromScreen(lp.x, lp.y, params->ViewDesc);

  if (params->ViewDesc->Kind==Z3D_VIEWMODE_USER)
  {
	  radiusx = (float)fabs(lp.x-params->loc->x);
	  radiusy = (float)fabs(lp.y-params->loc->y);
  }
  else
  {
	  radiusx = (float)fabs(fdivide(lp.x-params->loc->x, params->ViewDesc->Zoom));
	  radiusy = (float)fabs(fdivide(lp.y-params->loc->y, params->ViewDesc->Zoom));
  }

	if (IsTop(params->ViewDesc->Kind)) {radius.x = radiusx; radius.z = radiusy; radius.y = MAXFLOAT;}
	if (IsSide(params->ViewDesc->Kind)) {radius.z = radiusx; radius.y = radiusy; radius.x = MAXFLOAT;}
	if (IsFrontal(params->ViewDesc->Kind) ||
      (params->ViewDesc->Kind==Z3D_VIEWMODE_MAPPER) ||
      (params->ViewDesc->Kind==Z3D_VIEWMODE_USER))
  {radius.x = radiusx; radius.y = radiusy; radius.z = MAXFLOAT;}
	for (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
	{
		ProcessSelection(&params->Objects->ObjSet[ObjCount], *params->nFlags, &Center, &radius,
			params->ViewDesc, ((*params->nFlags & MK_SHIFT)==MK_SHIFT), 1);//1 is circle
	}
	
	return Z3D_PLUGRESULT_SELECTIONCHANGED;
}//circle select

